/**    
 * rmFx_cmdLineHandler4TB.js								//gW - 2008-0-05
 * 
 *  
 *	@see https://developer.mozilla.org/en/Chrome/Command_Line
 */

// const nsIAppShellService    = Components.interfaces.nsIAppShellService;
const nsISupports           = Components.interfaces.nsISupports;
const nsISupportsString        = Components.interfaces.nsISupportsString;

const nsICategoryManager    = Components.interfaces.nsICategoryManager;
const nsIComponentRegistrar = Components.interfaces.nsIComponentRegistrar;
// const nsICommandLine        = Components.interfaces.nsICommandLine;
const nsICommandLineHandler = Components.interfaces.nsICommandLineHandler;
const nsIFactory            = Components.interfaces.nsIFactory;
const nsIModule             = Components.interfaces.nsIModule;
const nsIWindowWatcher      = Components.interfaces.nsIWindowWatcher;

// CHANGEME: to the chrome URI of your extension or application
// const CHROME_URI = "chrome://reminderfox/content/";

// CHANGEME: change the contract id, CID, and category to be unique
// to your application.
const clh_contractID = "@mozilla.org/commandlinehandler/general-startup;1?type=reminderfox";

// use uuidgen to generate a unique ID
// CHANGE THIS !!
const clh_CID = Components.ID("{a52fd100-4b89-11dd-ae16-0800200c9a66}");

// category names are sorted alphabetically. Typical command-line handlers use a
// category that begins with the letter "m".
const clh_category = "m-reminderfox";

/** Utility functions
 */
 
/** The XPCOM component that implements nsICommandLineHandler.
 *  It also implements nsIFactory to serve as its own singleton factory.
 */
const rmFx_AppHandler = {
	
  /* nsISupports */
  QueryInterface : function clh_QI(iid)
  {
    if (iid.equals(nsICommandLineHandler) ||
        iid.equals(nsIFactory) ||
        iid.equals(nsISupports))
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /* nsICommandLineHandler */
      //    C:\>cd \programme\mozilla thunderbird\EN
      //    ..... >thunderbird.exe -reminderFox msgID:4755317C.2080205@web.de

  handle : function clh_handle(cmdLine) {
    try {
		// var rmFx_startupID = cmdLine.handleFlagWithParam("messageID", false);	
		var rmFx_startupID = cmdLine.handleFlagWithParam("reminderFox", false);	
		if (rmFx_startupID != null) {

      	var msgString = cmdLine.handleFlagWithParam("msgString", false);	

         var wwatch = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
                               .getService(nsIWindowWatcher);
         
         var argstring = Components.classes["@mozilla.org/supports-string;1"]
                                   .createInstance(nsISupportsString);
         argstring.data = rmFx_startupID + "|.|" + msgString;


         wwatch.openWindow(null, "chrome://reminderfox/content/mail/rmFxStartup4msgID.xul", 
            "msgID", "chrome,centerscreen", argstring);
         }
      }
    catch (e) {
      Components.utils.reportError("incorrect parameter passed to -reminderFox on the command line \n"+ e);
    }

  },

  // CHANGEME: change the help info as appropriate, but
  // follow the guidelines in nsICommandLineHandler.idl
  // specifically, flag descriptions should start at
  // character 24, and lines should be wrapped at
  // 72 characters with embedded newlines,
  // and finally, the string should end with a newline
  //  helpInfo : "  -myapp               Open My Application\n" +
  //           "  -viewapp <uri>       View and edit the URI in My Application,\n" +
  //           "                       wrapping this description\n",
  
  helpInfo : "  -msgID <msgID>       open TB with message msgID \n",

  /* nsIFactory */

  createInstance : function clh_CI(outer, iid)
  {
    if (outer != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;

    return this.QueryInterface(iid);
  },

  lockFactory : function clh_lock(lock)
  {
    /* no-op */
  }
};

/**
 * The XPCOM glue that implements nsIModule
 */
const rmFx_AppHandlerModule = {
  /* nsISupports */
  QueryInterface : function mod_QI(iid)
  {
    if (iid.equals(nsIModule) ||
        iid.equals(nsISupports))
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  /* nsIModule */
  getClassObject : function mod_gch(compMgr, cid, iid)
  {
    if (cid.equals(clh_CID))
      return rmFx_AppHandler.QueryInterface(iid);

    throw Components.results.NS_ERROR_NOT_REGISTERED;
  },

  registerSelf : function mod_regself(compMgr, fileSpec, location, type)
  {
    compMgr.QueryInterface(nsIComponentRegistrar);

    compMgr.registerFactoryLocation(clh_CID,
                                    "rmFx_AppHandler",
                                    clh_contractID,
                                    fileSpec,
                                    location,
                                    type);

    var catMan = Components.classes["@mozilla.org/categorymanager;1"].
      getService(nsICategoryManager);
    catMan.addCategoryEntry("command-line-handler",
                            clh_category,
                            clh_contractID, true, true);
  },

  unregisterSelf : function mod_unreg(compMgr, location, type)
  {
    compMgr.QueryInterface(nsIComponentRegistrar);
    compMgr.unregisterFactoryLocation(clh_CID, location);

    var catMan = Components.classes["@mozilla.org/categorymanager;1"].
      getService(nsICategoryManager);
    catMan.deleteCategoryEntry("command-line-handler", clh_category);
  },

  canUnload : function (compMgr)
  {
    return true;
  }
};

/* The NSGetModule function is the magic entry point that XPCOM uses to find what XPCOM objects
 * this component provides
 */
function NSGetModule(comMgr, fileSpec)
{
  return rmFx_AppHandlerModule;
}